<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->enum('Access_Level', ['basic', 'premium', 'enterprise'])->default('basic')->after('Description');
            $table->longText('Feature_Set')->charset('utf8mb4')->collation('utf8mb4_bin')->nullable()->after('Access_Level')->comment('JSON encoded features');
            $table->integer('Validity_Period')->nullable()->after('Feature_Set')->comment('Duration in days');
            $table->integer('Max_Job_Postings')->default(0)->after('Validity_Period');
        });
    }

    public function down(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn(['Access_Level', 'Feature_Set', 'Validity_Period', 'Max_Job_Postings']);
        });
    }
};
